<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChildName extends Model 
{

    protected $table = 'child_name';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'member_id');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

}