<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CheckList extends Model 
{

    protected $table = 'check_list';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'task_id', 'created_by');

    public function items()
    {
        return $this->hasMany('CheckItem', 'check_list_id');
    }

    public function task()
    {
        return $this->belongsTo('Task', 'task_id');
    }

    public function member()
    {
        return $this->belongsTo('Member', 'created_by');
    }

}