<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CheckItem extends Model 
{

    protected $table = 'check_item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('check_list_id', 'description', 'completed', 'created_by');

    public function list()
    {
        return $this->belongsTo('CheckList', 'check_list_id');
    }

    public function created_by()
    {
        return $this->belongsTo('Member', 'created_by');
    }

}