<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChatRead extends Model 
{

    protected $table = 'chat_read';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('member_id', 'chat_message_id');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

    public function chat_message()
    {
        return $this->belongsTo('ChatMessage', 'chat_message_id');
    }

}