<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChatMessage extends Model 
{

    protected $table = 'chat_message';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('sender_id', 'message', 'chat_id');

    public function chat()
    {
        return $this->belongsTo('Chat', 'chat_id');
    }

    public function sender()
    {
        return $this->belongsTo('Member', 'sender_id');
    }

    public function read()
    {
        return $this->belongsToMany('Member', 'chat_read', 'member_id', 'chat_message_id');
    }

}