<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChatMember extends Model 
{

    protected $table = 'chat_member';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('member_id', 'chat_id');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

    public function chat()
    {
        return $this->belongsTo('Chat', 'chat_id');
    }

}