<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Chat extends Model 
{

    protected $table = 'chat';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('last_message', 'group_id', 'project_id');

    public function group()
    {
        return $this->belongsTo('Group', 'group_id');
    }

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

    public function members()
    {
        return $this->belongsToMany('Member', 'chat_member', 'member_id', 'chat_id');
    }

}