<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Certification extends Model 
{

    protected $table = 'certification';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('university', 'level', 'univer', 'collage', 'degree', 'year', 'description', 'member_id');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

}