<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CalendarWord extends Model 
{

    protected $table = 'calendar_word';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('description', 'from_date', 'to_date', 'hide', 'member_id');

    public function member()
    {
        return $this->belongsTo('Member', 'member_id');
    }

}