<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Image extends Model 
{

    protected $table = 'images';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function blogimage()
    {
        return $this->belongsTo('Blog', 'entity_id');
    }

    public function commentimage()
    {
        return $this->belongsTo('Comment', 'entity_id');
    }

}