<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Groups extends Eloquent {

	protected $table = 'Groups';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');
	protected $visible = array('name', 'description');

	public function users()
	{
		return $this->belongsToMany('Users', 'id', 'id');
	}

}