<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BallotSubmission extends Eloquent {

	protected $table = 'BallotSubmission';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('electionID', 'selection', 'email');
	protected $visible = array('electionID', 'selection', 'email');

	public function election()
	{
		return $this->belongsTo('ElectionDefinition', 'id', 'id');
	}

}