<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('path');
			$table->string('extension');
			$table->boolean('image')->nullable();
			$table->boolean('contract')->nullable();
			$table->boolean('invoice')->nullable();
			$table->boolean('equipment');
			$table->integer('metadata_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->boolean('sepa')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}