<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('discounts', function(Blueprint $table) {
			$table->increments('id');
			$table->decimal('discount', 8,2);
			$table->decimal('lastminute', 8,2)->nullable();
			$table->decimal('premium', 8,2)->nullable();
			$table->string('active')->nullable();
			$table->integer('price_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('discounts');
	}
}