<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserAppdataTable extends Migration {

	public function up()
	{
		Schema::create('user_appdata', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->boolean('validate');
			$table->boolean('imported')->nullable()->default(false);
			$table->string('confirmation_code')->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('level_id')->unsigned();
			$table->boolean('newsletter')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_appdata');
	}
}