<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('commission');
			$table->string('due_date');
			$table->integer('price_id')->unsigned();
			$table->string('alert_time')->nullable();
			$table->integer('current_users_alert')->nullable();
			$table->boolean('maintenance')->nullable()->default(false);
			$table->integer('default_invoice_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}