<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMetadataValuesTable extends Migration {

	public function up()
	{
		Schema::create('metadata_values', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('metadata_id')->unsigned();
			$table->integer('locale_id')->unsigned();
			$table->string('title');
			$table->text('description')->nullable();
			$table->text('text')->nullable();
			$table->string('label');
			$table->string('value')->nullable();
			$table->string('alt')->nullable();
			$table->string('name');
		});
	}

	public function down()
	{
		Schema::drop('metadata_values');
	}
}