<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientPackagesTable extends Migration {

	public function up()
	{
		Schema::create('client_packages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('price');
			$table->string('number_matches');
			$table->string('duration');
			$table->string('duration_type');
			$table->enum('type', array('silver', 'gold', 'training'));
		});
	}

	public function down()
	{
		Schema::drop('client_packages');
	}
}