<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Goods', function(Blueprint $table) {
			$table->foreign('goodTypeId')->references('id')->on('GoodTypes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('CurrencyRates', function(Blueprint $table) {
			$table->foreign('currencyId')->references('id')->on('Currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('CompanyBrokers', function(Blueprint $table) {
			$table->foreign('companyId')->references('id')->on('Companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('CompanyBrokers', function(Blueprint $table) {
			$table->foreign('brokerId')->references('id')->on('Brokers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Offers', function(Blueprint $table) {
			$table->foreign('offerTypeId')->references('id')->on('Offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BrokerSessions', function(Blueprint $table) {
			$table->foreign('brokerId')->references('id')->on('Brokers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('BrokerSessions', function(Blueprint $table) {
			$table->foreign('sessionId')->references('id')->on('Sessions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Deals', function(Blueprint $table) {
			$table->foreign('offerId')->references('id')->on('Offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Goods', function(Blueprint $table) {
			$table->dropForeign('Goods_goodTypeId_foreign');
		});
		Schema::table('CurrencyRates', function(Blueprint $table) {
			$table->dropForeign('CurrencyRates_currencyId_foreign');
		});
		Schema::table('CompanyBrokers', function(Blueprint $table) {
			$table->dropForeign('CompanyBrokers_companyId_foreign');
		});
		Schema::table('CompanyBrokers', function(Blueprint $table) {
			$table->dropForeign('CompanyBrokers_brokerId_foreign');
		});
		Schema::table('Offers', function(Blueprint $table) {
			$table->dropForeign('Offers_offerTypeId_foreign');
		});
		Schema::table('BrokerSessions', function(Blueprint $table) {
			$table->dropForeign('BrokerSessions_brokerId_foreign');
		});
		Schema::table('BrokerSessions', function(Blueprint $table) {
			$table->dropForeign('BrokerSessions_sessionId_foreign');
		});
		Schema::table('Deals', function(Blueprint $table) {
			$table->dropForeign('Deals_offerId_foreign');
		});
	}
}