<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCelulaTbTable extends Migration {

	public function up()
	{
		Schema::create('celulaTb', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('nome', 200)->nullable();
			$table->integer('celulaMae')->unsigned();
			$table->enum('diaReuniao', array('Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado', 'Domingo'))->nullable();
			$table->time('horario')->nullable();
			$table->enum('tipo', array('Homens', 'Mulheres', 'Crianças'))->nullable();
			$table->date('dataInicio');
			$table->string('lider', 150)->nullable();
			$table->string('auxiliar', 150);
			$table->string('secretario', 150);
			$table->string('anfitriao', 150)->nullable();
			$table->string('endereco', 250)->nullable();
			$table->string('complemento', 250);
			$table->string('bairro', 100)->nullable();
			$table->string('cidade', 100)->nullable();
			$table->datetime('update')->nullable();
			$table->string('useCad', 150)->nullable();
			$table->integer('idIgreja')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('celulaTb');
	}
}