<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionTable extends Migration {

	public function up()
	{
		Schema::create('question', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 250);
			$table->string('qcode', 100);
			$table->integer('module_type_id');
			$table->string('help_text', 250);
			$table->integer('subquestion');
			$table->integer('skip');
			$table->tinyInteger('status');
			$table->string('validation', 250);
			$table->integer('answer_type');
		});
	}

	public function down()
	{
		Schema::drop('question');
	}
}