<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDevicesTable extends Migration {

	public function up()
	{
		Schema::create('devices', function(Blueprint $table) {
			$table->increments('id');
			$table->string('agent')->nullable();
			$table->string('node')->nullable();
			$table->string('os');
			$table->string('model');
			$table->string('mark')->nullable();
			$table->string('version');
			$table->integer('height')->nullable();
			$table->string('width');
			$table->string('longitude')->nullable();
			$table->string('latitude')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('devices');
	}
}