<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsAttributesTable extends Migration {

	public function up()
	{
		Schema::create('products_attributes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('product_id');
			$table->integer('sku');
			$table->string('size', 255);
			$table->string('purchase_price');
			$table->string('price');
			$table->string('color');
			$table->string('stock');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products_attributes');
	}
}