<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->text('description');
			$table->double('hours');
			$table->double('miuntes');
			$table->double('price');
			$table->double('discount_ratio');
			$table->date('expired_at');
			$table->string('image', 255);
			$table->text('video');
			$table->integer('order');
			$table->tinyInteger('availability')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}