<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('patient', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_family', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_family', function(Blueprint $table) {
			$table->foreign('sub_disease_id')->references('id')->on('sub_disease')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_family', function(Blueprint $table) {
			$table->foreign('family_relationship_id')->references('id')->on('family_relationships')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_allegries', function(Blueprint $table) {
			$table->foreign('allegries_id')->references('id')->on('allegries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_allegries', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_allegries', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('allegries', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('admin')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('specialities', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('admin')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sub_disease', function(Blueprint $table) {
			$table->foreign('speciality_id')->references('id')->on('specialities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sub_disease', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('admin')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_disease', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_disease', function(Blueprint $table) {
			$table->foreign('disease_id')->references('id')->on('sub_disease')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_disease', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_disease', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor_information')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('patient_medicine', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_medicine', function(Blueprint $table) {
			$table->foreign('consultation_id')->references('id')->on('consultation_logs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_medicine', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('case_refrence')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_medicine', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_information', function(Blueprint $table) {
			$table->foreign('speciality_id')->references('id')->on('specialities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('qualifications', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('admin')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_qualifications', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_qualifications', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('admin')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_qualifications', function(Blueprint $table) {
			$table->foreign('qualification_id')->references('id')->on('qualifications')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_feedback', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('uploaded', function(Blueprint $table) {
			$table->foreign('sub_disease_id')->references('id')->on('sub_disease')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('uploaded', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('case_refrence')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('uploaded', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultation_logs', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultation_logs', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->foreign('speciality_id')->references('id')->on('specialities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('question_id')->references('id')->on('questions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favorite_doctor', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favorite_doctor', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('prescription', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('prescription', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('prescription', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('case_refrence')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('prescription', function(Blueprint $table) {
			$table->foreign('consultation_id')->references('id')->on('consultation_logs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lab_test_user', function(Blueprint $table) {
			$table->foreign('lab_sub_id')->references('id')->on('lab_subcategries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lab_test_user', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lab_test_user', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lab_test_user', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('case_refrence')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('labs', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('admin')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lab_subcategries', function(Blueprint $table) {
			$table->foreign('lab_id')->references('id')->on('labs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lab_subcategries', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('admin')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_clinic', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_clinic', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('admin')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultation_details', function(Blueprint $table) {
			$table->foreign('consultation_history_id')->references('id')->on('consultation_logs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultation_details', function(Blueprint $table) {
			$table->foreign('prescription_id')->references('id')->on('prescription')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('consultation_details', function(Blueprint $table) {
			$table->foreign('medicine_id')->references('id')->on('patient_medicine')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultation_details', function(Blueprint $table) {
			$table->foreign('lab_test_user_id')->references('id')->on('lab_test_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clinic_time', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('clinic_time', function(Blueprint $table) {
			$table->foreign('clinic_id')->references('id')->on('doctor_clinic')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_clinic', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('patient_clinic', function(Blueprint $table) {
			$table->foreign('clinic_time_id')->references('id')->on('clinic_time')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('canceled_appointment', function(Blueprint $table) {
			$table->foreign('patient_clinic_id')->references('id')->on('patient_clinic')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('canceled_appointment', function(Blueprint $table) {
			$table->foreign('case_id')->references('id')->on('case_refrence')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('admin')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permession_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('vaccination', function(Blueprint $table) {
			$table->foreign('creator_id')->references('id')->on('admin')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_vaccination', function(Blueprint $table) {
			$table->foreign('vaccination_id')->references('id')->on('vaccination')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_vaccination', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_vaccination', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor_information')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('doctor_feedback', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_promo', function(Blueprint $table) {
			$table->foreign('promo_id')->references('id')->on('promo_codes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_promo', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patient')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_fees', function(Blueprint $table) {
			$table->foreign('speciality_id')->references('id')->on('specialities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('doctor_fees', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('doctor')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('patient', function(Blueprint $table) {
			$table->dropForeign('patient_doctor_id_foreign');
		});
		Schema::table('user_family', function(Blueprint $table) {
			$table->dropForeign('user_family_patient_id_foreign');
		});
		Schema::table('user_family', function(Blueprint $table) {
			$table->dropForeign('user_family_sub_disease_id_foreign');
		});
		Schema::table('user_family', function(Blueprint $table) {
			$table->dropForeign('user_family_family_relationship_id_foreign');
		});
		Schema::table('user_allegries', function(Blueprint $table) {
			$table->dropForeign('user_allegries_allegries_id_foreign');
		});
		Schema::table('user_allegries', function(Blueprint $table) {
			$table->dropForeign('user_allegries_patient_id_foreign');
		});
		Schema::table('user_allegries', function(Blueprint $table) {
			$table->dropForeign('user_allegries_doctor_id_foreign');
		});
		Schema::table('allegries', function(Blueprint $table) {
			$table->dropForeign('allegries_creator_id_foreign');
		});
		Schema::table('specialities', function(Blueprint $table) {
			$table->dropForeign('specialities_creator_id_foreign');
		});
		Schema::table('sub_disease', function(Blueprint $table) {
			$table->dropForeign('sub_disease_speciality_id_foreign');
		});
		Schema::table('sub_disease', function(Blueprint $table) {
			$table->dropForeign('sub_disease_creator_id_foreign');
		});
		Schema::table('user_disease', function(Blueprint $table) {
			$table->dropForeign('user_disease_patient_id_foreign');
		});
		Schema::table('user_disease', function(Blueprint $table) {
			$table->dropForeign('user_disease_disease_id_foreign');
		});
		Schema::table('user_disease', function(Blueprint $table) {
			$table->dropForeign('user_disease_creator_id_foreign');
		});
		Schema::table('user_disease', function(Blueprint $table) {
			$table->dropForeign('user_disease_doctor_id_foreign');
		});
		Schema::table('patient_medicine', function(Blueprint $table) {
			$table->dropForeign('patient_medicine_patient_id_foreign');
		});
		Schema::table('patient_medicine', function(Blueprint $table) {
			$table->dropForeign('patient_medicine_consultation_id_foreign');
		});
		Schema::table('patient_medicine', function(Blueprint $table) {
			$table->dropForeign('patient_medicine_case_id_foreign');
		});
		Schema::table('patient_medicine', function(Blueprint $table) {
			$table->dropForeign('patient_medicine_doctor_id_foreign');
		});
		Schema::table('doctor_information', function(Blueprint $table) {
			$table->dropForeign('doctor_information_speciality_id_foreign');
		});
		Schema::table('qualifications', function(Blueprint $table) {
			$table->dropForeign('qualifications_creator_id_foreign');
		});
		Schema::table('doctor_qualifications', function(Blueprint $table) {
			$table->dropForeign('doctor_qualifications_doctor_id_foreign');
		});
		Schema::table('doctor_qualifications', function(Blueprint $table) {
			$table->dropForeign('doctor_qualifications_creator_id_foreign');
		});
		Schema::table('doctor_qualifications', function(Blueprint $table) {
			$table->dropForeign('doctor_qualifications_qualification_id_foreign');
		});
		Schema::table('patient_feedback', function(Blueprint $table) {
			$table->dropForeign('patient_feedback_patient_id_foreign');
		});
		Schema::table('uploaded', function(Blueprint $table) {
			$table->dropForeign('uploaded_sub_disease_id_foreign');
		});
		Schema::table('uploaded', function(Blueprint $table) {
			$table->dropForeign('uploaded_case_id_foreign');
		});
		Schema::table('uploaded', function(Blueprint $table) {
			$table->dropForeign('uploaded_patient_id_foreign');
		});
		Schema::table('consultation_logs', function(Blueprint $table) {
			$table->dropForeign('consultation_logs_doctor_id_foreign');
		});
		Schema::table('consultation_logs', function(Blueprint $table) {
			$table->dropForeign('consultation_logs_patient_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_patient_id_foreign');
		});
		Schema::table('questions', function(Blueprint $table) {
			$table->dropForeign('questions_speciality_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_question_id_foreign');
		});
		Schema::table('answers', function(Blueprint $table) {
			$table->dropForeign('answers_doctor_id_foreign');
		});
		Schema::table('favorite_doctor', function(Blueprint $table) {
			$table->dropForeign('favorite_doctor_doctor_id_foreign');
		});
		Schema::table('favorite_doctor', function(Blueprint $table) {
			$table->dropForeign('favorite_doctor_patient_id_foreign');
		});
		Schema::table('prescription', function(Blueprint $table) {
			$table->dropForeign('prescription_patient_id_foreign');
		});
		Schema::table('prescription', function(Blueprint $table) {
			$table->dropForeign('prescription_doctor_id_foreign');
		});
		Schema::table('prescription', function(Blueprint $table) {
			$table->dropForeign('prescription_case_id_foreign');
		});
		Schema::table('prescription', function(Blueprint $table) {
			$table->dropForeign('prescription_consultation_id_foreign');
		});
		Schema::table('lab_test_user', function(Blueprint $table) {
			$table->dropForeign('lab_test_user_lab_sub_id_foreign');
		});
		Schema::table('lab_test_user', function(Blueprint $table) {
			$table->dropForeign('lab_test_user_doctor_id_foreign');
		});
		Schema::table('lab_test_user', function(Blueprint $table) {
			$table->dropForeign('lab_test_user_patient_id_foreign');
		});
		Schema::table('lab_test_user', function(Blueprint $table) {
			$table->dropForeign('lab_test_user_case_id_foreign');
		});
		Schema::table('labs', function(Blueprint $table) {
			$table->dropForeign('labs_creator_id_foreign');
		});
		Schema::table('lab_subcategries', function(Blueprint $table) {
			$table->dropForeign('lab_subcategries_lab_id_foreign');
		});
		Schema::table('lab_subcategries', function(Blueprint $table) {
			$table->dropForeign('lab_subcategries_creator_id_foreign');
		});
		Schema::table('doctor_clinic', function(Blueprint $table) {
			$table->dropForeign('doctor_clinic_doctor_id_foreign');
		});
		Schema::table('doctor_clinic', function(Blueprint $table) {
			$table->dropForeign('doctor_clinic_creator_id_foreign');
		});
		Schema::table('consultation_details', function(Blueprint $table) {
			$table->dropForeign('consultation_details_consultation_history_id_foreign');
		});
		Schema::table('consultation_details', function(Blueprint $table) {
			$table->dropForeign('consultation_details_prescription_id_foreign');
		});
		Schema::table('consultation_details', function(Blueprint $table) {
			$table->dropForeign('consultation_details_medicine_id_foreign');
		});
		Schema::table('consultation_details', function(Blueprint $table) {
			$table->dropForeign('consultation_details_lab_test_user_id_foreign');
		});
		Schema::table('clinic_time', function(Blueprint $table) {
			$table->dropForeign('clinic_time_doctor_id_foreign');
		});
		Schema::table('clinic_time', function(Blueprint $table) {
			$table->dropForeign('clinic_time_clinic_id_foreign');
		});
		Schema::table('patient_clinic', function(Blueprint $table) {
			$table->dropForeign('patient_clinic_patient_id_foreign');
		});
		Schema::table('patient_clinic', function(Blueprint $table) {
			$table->dropForeign('patient_clinic_clinic_time_id_foreign');
		});
		Schema::table('canceled_appointment', function(Blueprint $table) {
			$table->dropForeign('canceled_appointment_patient_clinic_id_foreign');
		});
		Schema::table('canceled_appointment', function(Blueprint $table) {
			$table->dropForeign('canceled_appointment_case_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permession_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('vaccination', function(Blueprint $table) {
			$table->dropForeign('vaccination_creator_id_foreign');
		});
		Schema::table('user_vaccination', function(Blueprint $table) {
			$table->dropForeign('user_vaccination_vaccination_id_foreign');
		});
		Schema::table('user_vaccination', function(Blueprint $table) {
			$table->dropForeign('user_vaccination_patient_id_foreign');
		});
		Schema::table('user_vaccination', function(Blueprint $table) {
			$table->dropForeign('user_vaccination_doctor_id_foreign');
		});
		Schema::table('doctor_feedback', function(Blueprint $table) {
			$table->dropForeign('doctor_feedback_doctor_id_foreign');
		});
		Schema::table('user_promo', function(Blueprint $table) {
			$table->dropForeign('user_promo_promo_id_foreign');
		});
		Schema::table('user_promo', function(Blueprint $table) {
			$table->dropForeign('user_promo_patient_id_foreign');
		});
		Schema::table('doctor_fees', function(Blueprint $table) {
			$table->dropForeign('doctor_fees_speciality_id_foreign');
		});
		Schema::table('doctor_fees', function(Blueprint $table) {
			$table->dropForeign('doctor_fees_doctor_id_foreign');
		});
	}
}