<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserVaccinationTable extends Migration {

	public function up()
	{
		Schema::create('user_vaccination', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('vaccination_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->integer('doctor_id')->unsigned();
			$table->string('other_vaccination', 250)->nullable();
			$table->integer('status')->default('0');
			$table->boolean('still_has');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_vaccination');
	}
}