<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientTable extends Migration {

	public function up()
	{
		Schema::create('patient', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('doctor_id')->unsigned()->default('0');
			$table->string('name', 250);
			$table->string('email', 250)->nullable();
			$table->string('password', 250)->nullable();
			$table->string('last_name', 250)->nullable();
			$table->integer('age')->default('0');
			$table->string('city', 250)->nullable();
			$table->integer('phone_number')->default('0');
			$table->boolean('fb_login');
			$table->string('gender', 250)->nullable();
			$table->string('photo', 250)->nullable();
			$table->datetime('last_login_at');
			$table->string('last_login_ip_address', 250)->nullable();
			$table->datetime('doctor_last_edit');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('patient');
	}
}