<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePatientMedicineTable extends Migration {

	public function up()
	{
		Schema::create('patient_medicine', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('patient_id')->unsigned();
			$table->integer('consultation_id')->unsigned();
			$table->integer('case_id')->unsigned();
			$table->integer('doctor_id')->unsigned();
			$table->string('duration', 250)->nullable();
			$table->string('frequency', 250)->nullable();
			$table->string('condition', 250)->nullable();
			$table->string('comment', 250)->nullable();
			$table->string('typ', 250);
			$table->string('doctor_comment', 250)->nullable();
			$table->string('name', 250);
			$table->string('dosage', 250);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('patient_medicine');
	}
}