<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorTable extends Migration {

	public function up()
	{
		Schema::create('doctor', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 250);
			$table->string('email', 250);
			$table->string('password', 250);
			$table->integer('age');
			$table->string('city', 250);
			$table->integer('phone_number');
			$table->string('gender', 250);
			$table->string('photo', 250);
			$table->integer('consultation_minuts')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('doctor');
	}
}