<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorClinicTable extends Migration {

	public function up()
	{
		Schema::create('doctor_clinic', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('doctor_id')->unsigned();
			$table->integer('creator_id')->unsigned();
			$table->string('place_name', 250)->nullable();
			$table->string('latitude', 250)->nullable();
			$table->string('longitude', 250)->nullable();
			$table->integer('max_num')->default('0');
			$table->string('fees', 250)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('doctor_clinic');
	}
}