<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsultationDetailsTable extends Migration {

	public function up()
	{
		Schema::create('consultation_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('consultation_history_id')->unsigned();
			$table->string('doctor_comment', 250)->nullable();
			$table->integer('prescription_id')->unsigned()->default('0');
			$table->integer('medicine_id')->unsigned();
			$table->integer('lab_test_user_id')->unsigned()->default('0');
			$table->string('comment', 250)->nullable();
			$table->text('diagnosis');
			$table->boolean('is_completed');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('consultation_details');
	}
}