<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CadastroAutorizacaoVeicular extends Model 
{

    protected $table = 'cadastro_autorizacao_veicular';
    public $timestamps = true;

    public function PerteceAUmaPessoa()
    {
        return $this->hasOne('Pessoa');
    }

    public function PodePossuirProcurador()
    {
        return $this->hasOne('Pessoa');
    }

    public function PossuiVeiculos()
    {
        return $this->hasManyThrough('Veiculo');
    }

    public function PossuiHistorico()
    {
        return $this->hasMany('HistoricoCAV');
    }

}