<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVeiculoOnibusTable extends Migration {

	public function up()
	{
		Schema::create('veiculo_onibus', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('qte_passageiros');
			$table->string('cert_propriedade');
			$table->string('carroceria');
			$table->date('adquirido_em');
			$table->string('num_contrato_concessao');
			$table->integer('potencia_motor_cv');
			$table->enum('tipo_onibus', array('CONVENCIONAL', 'SELETIVO'));
			$table->string('sum_equip_GPS');
			$table->date('inicio_operacao');
			$table->date('fim_operacao');
			$table->string('processo_inclusao');
			$table->string('processo_baixa');
			$table->boolean('is_articulado')->default(false);
			$table->boolean('is_accessibility')->default(false);
			$table->boolean('is_microonibus')->default(false);
			$table->boolean('have_camera')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('veiculo_onibus');
	}
}