<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('lotes', function(Blueprint $table) {
			$table->foreign('leilao_id')->references('id')->on('leiloes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lotes', function(Blueprint $table) {
			$table->foreign('vendedor_id')->references('id')->on('vendedores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('arremates', function(Blueprint $table) {
			$table->foreign('comprador_id')->references('id')->on('compradores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('arremates', function(Blueprint $table) {
			$table->foreign('lote_id')->references('id')->on('lotes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('parcelas', function(Blueprint $table) {
			$table->foreign('arremate_id')->references('id')->on('arremates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('boletos', function(Blueprint $table) {
			$table->foreign('parcela_id')->references('id')->on('parcelas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pagamentos', function(Blueprint $table) {
			$table->foreign('parcela_id')->references('id')->on('parcelas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('lotes', function(Blueprint $table) {
			$table->dropForeign('lotes_leilao_id_foreign');
		});
		Schema::table('lotes', function(Blueprint $table) {
			$table->dropForeign('lotes_vendedor_id_foreign');
		});
		Schema::table('arremates', function(Blueprint $table) {
			$table->dropForeign('arremates_comprador_id_foreign');
		});
		Schema::table('arremates', function(Blueprint $table) {
			$table->dropForeign('arremates_lote_id_foreign');
		});
		Schema::table('parcelas', function(Blueprint $table) {
			$table->dropForeign('parcelas_arremate_id_foreign');
		});
		Schema::table('boletos', function(Blueprint $table) {
			$table->dropForeign('boletos_parcela_id_foreign');
		});
		Schema::table('pagamentos', function(Blueprint $table) {
			$table->dropForeign('pagamentos_parcela_id_foreign');
		});
	}
}