<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('exercises', function(Blueprint $table) {
			$table->foreign('exercise_type_id')->references('id')->on('exercise_types')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('exercises', function(Blueprint $table) {
			$table->foreign('exercise_equipment_id')->references('id')->on('exercise_equipments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('workouts', function(Blueprint $table) {
			$table->foreign('workout_type_id')->references('id')->on('workouts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('junctions', function(Blueprint $table) {
			$table->foreign('exercise_id')->references('id')->on('exercises')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('junctions', function(Blueprint $table) {
			$table->foreign('workout_id')->references('id')->on('workouts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->foreign('workout_id')->references('id')->on('workouts')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('targets', function(Blueprint $table) {
			$table->foreign('junction_id')->references('id')->on('junctions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('log_entries', function(Blueprint $table) {
			$table->foreign('log_id')->references('id')->on('logs')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('log_entries', function(Blueprint $table) {
			$table->foreign('junction_id')->references('id')->on('junctions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('exercises', function(Blueprint $table) {
			$table->dropForeign('exercises_exercise_type_id_foreign');
		});
		Schema::table('exercises', function(Blueprint $table) {
			$table->dropForeign('exercises_exercise_equipment_id_foreign');
		});
		Schema::table('workouts', function(Blueprint $table) {
			$table->dropForeign('workouts_workout_type_id_foreign');
		});
		Schema::table('junctions', function(Blueprint $table) {
			$table->dropForeign('junctions_exercise_id_foreign');
		});
		Schema::table('junctions', function(Blueprint $table) {
			$table->dropForeign('junctions_workout_id_foreign');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->dropForeign('logs_workout_id_foreign');
		});
		Schema::table('targets', function(Blueprint $table) {
			$table->dropForeign('targets_junction_id_foreign');
		});
		Schema::table('log_entries', function(Blueprint $table) {
			$table->dropForeign('log_entries_log_id_foreign');
		});
		Schema::table('log_entries', function(Blueprint $table) {
			$table->dropForeign('log_entries_junction_id_foreign');
		});
	}
}