<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVehiculosTable extends Migration {

	public function up()
	{
		Schema::create('vehiculos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_cliente')->unsigned()->nullable();
			$table->integer('id_status')->unsigned()->nullable();
			$table->integer('id_tipo_vehiculo')->unsigned()->nullable();
			$table->integer('id_chofer')->unsigned()->nullable();
			$table->string('num_vehiculo', 10);
			$table->string('foto_num_vehiculo', 100);
			$table->string('marca', 60);
			$table->string('foto_marca', 100);
			$table->string('modelo', 60);
			$table->string('foto_modelo', 100);
			$table->string('placas', 20);
			$table->string('foto_placas', 100);
			$table->string('vin', 50);
			$table->string('foto_vin', 100);
			$table->string('color', 30);
			$table->string('foto_vehiculo', 100);
			$table->integer('id_usuario_registro')->unsigned()->nullable();
			$table->integer('id_usuario_ult_mod')->unsigned()->nullable();
			$table->timestamps();
			$table->string('marca_llanta_extra', 30);
			$table->string('foto_marca_llanta_extra', 100);
		});
	}

	public function down()
	{
		Schema::drop('vehiculos');
	}
}