<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsuariosTable extends Migration {

	public function up()
	{
		Schema::create('usuarios', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_tipo_usuario')->unsigned()->nullable();
			$table->integer('id_cliente')->unsigned()->nullable();
			$table->string('foto_usuario', 100);
			$table->string('nombre', 60);
			$table->string('apellido', 60);
			$table->string('correo', 60);
			$table->string('password', 200);
			$table->string('sexo', 60);
			$table->string('prefijo_tel_pais', 10);
			$table->string('telefono', 60);
			$table->string('idioma', 20);
			$table->integer('id_usuario_registro')->unsigned()->nullable();
			$table->integer('id_usuario_ult_mod')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('usuarios');
	}
}