<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateChoferesTable extends Migration {

	public function up()
	{
		Schema::create('choferes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_cliente')->unsigned()->nullable();
			$table->string('nombre', 60);
			$table->string('apellido_paterno', 60);
			$table->string('apellido_materno', 60);
			$table->string('num_licencia', 60);
			$table->string('foto_licencia', 10);
			$table->string('sexo', 60);
			$table->string('prefijo_tel_pais', 10);
			$table->string('telefono', 60);
			$table->string('email', 60);
			$table->text('direccion');
			$table->datetime('fecha_nacimiento');
			$table->string('foto_chofer', 100);
			$table->integer('id_status')->unsigned()->nullable();
			$table->integer('id_usuario_registro')->unsigned()->nullable();
			$table->integer('id_usuario_ult_mod')->unsigned()->nullable();
			$table->timestamps();
			$table->integer('id_vehiculo')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('choferes');
	}
}