<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpensesTable extends Migration {

	public function up()
	{
		Schema::create('expenses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('account_id')->nullable();
			$table->double('amount')->nullable();
			$table->datetime('date')->nullable();
			$table->text('note')->nullable();
			$table->enum('type', array('capital', 'consumed'))->nullable();
			$table->string('expense_item')->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('expenses');
	}
}