<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Installmentpayments extends Model 
{

    protected $table = 'installmentpayments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('type', 'amount', 'installment_id', 'note', 'user_id');

    public function invoice()
    {
        return $this->belongsTo('Installmentinvoices', 'installment_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}