<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ReturnedItems extends Model 
{

    protected $table = 'returned_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('returned_id', 'product_id', 'price', 'quantity', 'total');

    public function returned()
    {
        return $this->belongsTo('Returned', 'returned_id');
    }

    public function product()
    {
        return $this->belongsTo('Products', 'product_id');
    }

}