<?php

namespace App\Models;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;
	protected $fillable = array('phone', 'email', 'password', 'name', 'blood_type_id', 'last_donation_date', 'pin_code', 'city_id');

	public function blooddType()
	{
		return $this->belongsTo('App\Models\BloodType');
	}

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function posts()
	{
		return $this->belongsToMany('App\Models\Post');
	}

	public function donationRequests()
	{
		return $this->hasMany('App\Models\DonationRequest');
	}

	public function notifications()
	{
		return $this->belongsToMany('App\Models\Notification');
	}

	public function Governorates()
	{
		return $this->belongsToMany('App\Models\Governorate');
	}

	public function blooddTypes()
	{
		return $this->belongsToMany('App\Models\BloodType');
	}

}