<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->increments('uid');
			$table->text('Username');
			$table->text('Password');
			$table->text('Email');
			$table->string('FirstName', 20);
			$table->string('LastName', 20);
			$table->enum('Role', array('Teacher', 'Student'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}