<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppointmentsTable extends Migration {

	public function up()
	{
		Schema::create('appointments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('doctor_id')->unsigned();
			$table->integer('patient_id')->unsigned();
			$table->string('description', 191);
			$table->string('image', 191);
			$table->enum('status', array(''pending'', ''approved'', ''rejected''));
			$table->date('day');
			$table->time('time');
			$table->integer('branch_id')->unsigned();
			$table->integer('room_id')->unsigned();
			$table->string('type', 191);
			$table->date('last_appointment');
		});
	}

	public function down()
	{
		Schema::drop('appointments');
	}
}