<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('email', 191)->unique();
			$table->string('password', 191);
			$table->integer('role_id')->unsigned();
			$table->string('phone', 191);
			$table->string('image', 191);
			$table->boolean('is_doctor');
			$table->integer('branch_id')->unsigned();
			$table->string('job', 191);
			$table->integer('salary');
			$table->string('specialization', 191);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}