<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('order_id')->unsigned();
			$table->integer('amount')->unsigned();
			$table->integer('unit_price')->unsigned();
			$table->integer('gross_price')->unsigned();
			$table->smallInteger('vat_value');
			$table->bigInteger('product_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}