<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('discount_id', 'pre_order_amount', 'tax_amount', 'discount_amount', 'total_amount', 'date', 'status');

	public function promocode()
	{
		return $this->hasOne('Promocode', 'discount_id');
	}

	public function user()
	{
		return $this->hasOne('User', 'user_id');
	}

	public function orderitems()
	{
		return $this->hasMany('OrderItem', 'order_id');
	}

}