<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->string('sku', 255)->nullable();
			$table->string('short_description', 255)->nullable();
			$table->text('long_description')->nullable();
			$table->float('price')->nullable();
			$table->float('ratings')->nullable();
			$table->integer('rating_count')->nullable();
			$table->integer('stock')->nullable();
			$table->enum('status', array('Active', 'Deactive'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}