<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Products extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'sku', 'short_description', 'long_description', 'price', 'status');

    public function ratings()
    {
        return $this->hasMany('ProductRating', 'product_id');
    }

    public function images()
    {
        return $this->hasMany('ProductImage', 'product_id');
    }

}