<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TcQuestionAnswer extends Model 
{

    protected $table = 'tc_question_answers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('tc_establishment_id', 'tc_form_id', 'tc_question_id', 'answer');

    public function user()
    {
        return $this->belongsTo('App/Model\TcEstablishment');
    }

    public function question()
    {
        return $this->belongsTo('App/Model\TcQuestion');
    }

}